/**
 *	Copyright (C) 2011-2013 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.docutools.gui;
/**
 *
 */


import java.awt.BorderLayout;
import java.awt.Dimension;

import javax.swing.*;

import ch.docuteam.docutools.out.SystemOutRedirectionTarget;
import ch.docuteam.docutools.out.SystemOutRedirector;

/**
 * @author denis
 *
 */
public class SystemOutView extends JFrame implements SystemOutRedirectionTarget
{
	//	===========================================================================================
	//	========	Structure				=======================================================
	//	===========================================================================================

	//	========	Static Final Public		=======================================================

	//	========	Static Final Private	=======================================================

	static private final String		ScreenTitle = "Console";
	static private Dimension		StartScreenSize = new Dimension(600, 400);

	//	========	Static Public			=======================================================

	static private SystemOutView	SoleInstance;

	/**
	 * To swich on or off that the SystemOutView automatically opens when an input occurs:
	 */
	static private boolean			DoPopUpOnWrite = true;

	//	========	Static Private			=======================================================

	//	========	Instance Public			=======================================================

	//	========	Instance Private		=======================================================

	private JTextArea				consoleMessagesTextArea;

	//	===========================================================================================
	//	========	Methods					=======================================================
	//	===========================================================================================

	//	========	Static Initializer		=======================================================

	//	========	Constructors Public		=======================================================

	//	========	Constructors Private	=======================================================

	public SystemOutView()
	{
		this("<html>An unexpected error occurred. Please copy this message and send it to the Dev Team<br>together with a brief description of what you did before this happened. Thank you.</html>");
	}

	/**
	 * The header text can be plain text or html code.
	 * @param headerText Text to be displayed as the header of the SystemOutView.
	 */
	public SystemOutView(String headerText)
	{
		super(ScreenTitle);
		this.setAlwaysOnTop(true);

		this.consoleMessagesTextArea = new JTextArea();
		this.consoleMessagesTextArea.setEnabled(true);
		this.consoleMessagesTextArea.setEditable(false);
		this.consoleMessagesTextArea.setLineWrap(false);

		this.add(new JLabel(headerText), BorderLayout.NORTH);
		this.add(new JScrollPane(this.consoleMessagesTextArea), BorderLayout.CENTER);

		this.setPreferredSize(StartScreenSize);
		this.pack();
		this.setLocationRelativeTo(null);

		SoleInstance = this;
	}

	//	========	Static Public			=======================================================

	static public void install()
	{
		SystemOutRedirector.install(new SystemOutView());
	}


	static public void open()
	{
		if (SoleInstance == null)		SoleInstance = new SystemOutView();
		SoleInstance.setVisible(true);
	}


	static public void setDoPopUpOnWrite(boolean doPopUpOnWrite)
	{
		DoPopUpOnWrite = doPopUpOnWrite;
	}


	static public boolean doPopUpOnWrite()
	{
		return DoPopUpOnWrite;
	}

	//	========	Static Private			=======================================================

	//	========	Instance Public			=======================================================

	//	--------		Accessing			-------------------------------------------------------
	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Interface			-------------------------------------------------------

	/* (non-Javadoc)
	 * @see doculib.util.SystemOutRedirectionTarget#write(java.lang.String)
	 */
	@Override
	public void write(String string)
	{
		this.consoleMessagesTextArea.append(string);
		if (DoPopUpOnWrite)		this.setVisible(true);
	}

	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------
	//	---------		Temporary			-------------------------------------------------------

	//	========	Instance Private		=======================================================

	//	--------		Initializing		-------------------------------------------------------
	//	--------		Accessing			-------------------------------------------------------
	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------
	//	---------		Temporary			-------------------------------------------------------

	//	===========================================================================================
	//	========	Inner Classes			=======================================================
	//	===========================================================================================

}
