/**
 *	Copyright (C) 2011-2013 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.docudarc.mdconfig;

import ch.docuteam.docudarc.mets.structmap.NodeAbstract;
import ch.docuteam.docutools.string.StringUtil;


/**
 * A MetadataElementValidator that only accepts a positive short value between 0 and 32767.
 *
 * @author denis
 *
 */
public class MetadataElementValidatorShort implements MetadataElementValidator
{
	/* (non-Javadoc)
	 * @see ch.docuteam.docudarc.ead.DataElementValidator#check(java.lang.String, java.lang.Object)
	 */
	@Override
	public String check(String value, NodeAbstract context, MetadataElement metadataElement)
	{
		if (!StringUtil.isNumeric(value))		return "Not numeric: '" + value + "'";
		if (value.length() > 5)					return "Max 5 digits: '" + value + "'";

		try
		{
			int number = new Integer(value);
			if (number > Short.MAX_VALUE)		return "Must be <= " + Short.MAX_VALUE + ": '" + value + "'";
		}
		catch (NumberFormatException ex)
		{
			return "Can't convert to number: '" + value + "'";
		}

		return null;
	}

}
