package ch.docuteam.docudarc.util;

import gov.loc.mets.FileType;
import gov.loc.mets.MetsType.FileSec.FileGrp;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Observer;

import ch.docuteam.docudarc.mdconfig.LevelOfDescription;
import ch.docuteam.docudarc.mets.Document;
import ch.docuteam.docudarc.mets.structmap.*;
import ch.docuteam.docudarc.mets.structmap.NodeAbstract.SubmitStatus;
import ch.docuteam.docutools.exception.Exception;
import ch.docuteam.docutools.exception.ExceptionCollector;
import ch.docuteam.docutools.file.FileUtil;
import ch.docuteam.docutools.os.OperatingSystem;
import ch.docuteam.docutools.out.Tracer;

import com.exlibris.core.sdk.consts.Enum;
import com.exlibris.core.sdk.formatting.DublinCore;
import com.exlibris.core.sdk.formatting.DublinCoreFactory;
import com.exlibris.digitool.common.dnx.*;
import com.exlibris.dps.sdk.deposit.IEParser;
import com.exlibris.dps.sdk.deposit.IEParserFactory;

/**
 * Convert a Matterhorn-SIP to Rosetta-IEs and Rosetta-Collections.
 * @author denis
 *
 */
public abstract class RosettaConverter
{
	//	===========================================================================================
	//	========	Structure				=======================================================
	//	===========================================================================================

	//	========	Static Final Public		=======================================================

	//	========	Static Final Private	=======================================================

	//	========	Static Public			=======================================================

	//	========	Static Private			=======================================================

	//	===========================================================================================
	//	========	Main					=======================================================
	//	===========================================================================================

	static public void main(String... args)
	{
		String desktop = OperatingSystem.userHome() + "/Desktop/";

		String sipName = "IngestTest_SubmitRequested";
//		String sipName = "DifferentLevelsSubmitRequested";

		Document doc = null;
		try
		{
			//	Reset the submit status of all nodes to "Undefined":
//			doc = Document.openReadWrite(desktop + "SIPs/" + sipName, "Document.main");
//			for (NodeAbstract n: doc.getStructureMap().getRoot().getWithDescendants())		n.setSubmitStatus_force(SubmitStatus.Undefined);
//			doc.saveWithoutBackup();

			//	Mark all nodes as "submitRequested":
//			doc = Document.openReadWrite(desktop + "SIPs/" + sipName, "Document.main");
//			doc.getStructureMap().getRoot().setSubmitRequested_recursive();
//			doc.saveWithoutBackup();

			//	Mark all nodes marked as "submitRequested" as "submitRequestPending" and copy the SIP to the ingest drop folder:
//			doc = Document.openReadWrite(desktop + "SIPs/" + sipName, "Document.main");
//			Tracer.trace(doc.submit(desktop + "IngestDropFolder"));

			//	Create IEs and Collections from the nodes marked as "submitRequestPending":
			RosettaConverter.convertTo(desktop + "IngestDropFolder/" + sipName, desktop + "IEs/" + sipName, "Document.main");

//			Tracer.trace(doc);		//	ToDo
		}
		catch (Throwable x)
		{
			x.printStackTrace();
		}
		finally
		{
			if (!ExceptionCollector.isEmpty())		Tracer.trace(ExceptionCollector.toStringAll());

			try
			{
				if (doc != null)
				{
					doc.unlockIfNecessary();
					doc.cleanupWorkingCopy();
				}
			}
			catch (java.lang.Exception e)
			{
				e.printStackTrace();
			}
		}

	}

	//	===========================================================================================
	//	========	Methods					=======================================================
	//	===========================================================================================

	//	========	Static Initializer		=======================================================

	//	========	Static Public			=======================================================

	//	--------		Initializing		-------------------------------------------------------
	//	--------		Accessing			-------------------------------------------------------
	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Business Ops		-------------------------------------------------------

	static public void convertTo(String docPath, String destinationFolder) throws java.lang.Exception
	{
		convertTo(docPath, destinationFolder, "");
	}

	static public void convertTo(String barSIPPath, String newZIPOrFolderFilePath, String operatorName) throws java.lang.Exception
	{
		convertTo(barSIPPath, newZIPOrFolderFilePath, operatorName, null);
	}

	/**
	 * For all nodes in document that are marked as "SubmitRequestPending", create an IE or Collection in the destination folder.
	 * @throws java.lang.Exception
	 */
	static public void convertTo(String sipPath, String destinationFolder, String operatorName, Observer observer) throws java.lang.Exception
	{
		Document document = Document.openReadOnly(sipPath, operatorName, observer);

		FileUtil.delete(destinationFolder);
		convertTo(document.getStructureMap().getRoot(), destinationFolder);
	}

	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	---------		Misc				-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------
	//	---------		Temporary			-------------------------------------------------------

	//	========	Static Private			=======================================================

	//	--------		Initializing		-------------------------------------------------------
	//	--------		Accessing			-------------------------------------------------------
	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Business Ops		-------------------------------------------------------
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------

	/**
	 * @param node
	 * @param destinationFolder
	 * @throws java.lang.Exception
	 */
	static private void convertTo(NodeAbstract node, String destinationFolder) throws java.lang.Exception
	{
		//	If this node is a file, create an IE (any restrictions on the node's level?):
		if (node.isFile())		createIE(node, destinationFolder);
		else
		{
			//	Any restrictions on the node's level?

			//	If this folder is empty, create a Collection (?):
			if (node.getChildCount() == 0)		createCollection((NodeFolder)node, destinationFolder);
			else
			{
				//	If all node's children have the level "Undefined", create a complex IE with multiple subfiles.
				//	If at least one child has a level other than "Undefined", create a Collection.
				boolean isSubmitIEType = true;

				for (int i = 0; i < node.getChildCount(); i++)
					if (((NodeAbstract)node.getChildAt(i)).getLevel() != LevelOfDescription.getUndefined())
					{
						isSubmitIEType = false;
						break;
					}

				if (isSubmitIEType)		createIE(node, destinationFolder);
				else
				{
					createCollection((NodeFolder)node, destinationFolder);

					//	Recurse into the children:
					for (int i = 0; i < node.getChildCount(); i++)		convertTo((NodeAbstract)node.getChildAt(i), destinationFolder);
				}
			}
		}
	}

	//	--------		low-Level ingest	-------------------------------------------------------

	/**
	 * Create a Collection in the destination folder.
	 * @param destinationFolder
	 * @throws Exception
	 * Don't do anything if the node's submit status is NOT SubmitStatusPending.
	 */
	static private void createCollection(NodeFolder node, String destinationFolder)
	{
		if (node.getSubmitStatus() != SubmitStatus.SubmitRequestPending)		return;

		Tracer.trace("Creating Collection in '" + destinationFolder + "' for: " + node.getPathString());

		//	ToDo: Still open: how to create a Collection?
	}


	/**
	 * Create an IE out of the node passed. There are 2 different modes:
	 * 	1: node is a file (= simple IE)
	 * 	2: node is a folder with children (= complex IE)
	 * Don't do anything if the node's submit status is NOT SubmitStatusPending.
	 * @param node
	 * @param destinationFolder
	 * @throws java.lang.Exception
	 */
	@SuppressWarnings("deprecation")
	static private void createIE(NodeAbstract node, String destinationFolder) throws java.lang.Exception
	{
		if (node.getSubmitStatus() != SubmitStatus.SubmitRequestPending)		return;

		String destinationRootPath = destinationFolder + "/" + node.getLabel();
		String ieFilePath = destinationRootPath + "/content/ie.xml";
		String dcFilePath = destinationRootPath + "/content/dc.xml";
		String streamsFilePath = destinationRootPath + "/content/streams";

		Tracer.trace("Creating DC in '" + destinationFolder + "' for: " + node.getLabel());

		//	Create dc.xml:
		DublinCore dc = DublinCoreFactory.getInstance().createDocument();
		dc.addElement("dc:title", node.getUnitTitle().substring(0, Math.min(node.getUnitTitle().length(), 127)));
		new File(dcFilePath).getParentFile().mkdirs();
		dc.save(dcFilePath);

		Tracer.trace("Creating IE in '" + destinationFolder + "' for: " + node.getLabel());

		//	Create ie.xml and copy files to content/streams/:

		//	Create IE:
		IEParser ie = IEParserFactory.create();

		//	Add DC to IE:
		dc = ie.getDublinCoreParser();
		//	What's set here comes into the dmd section:
		dc.addElement("dc:title", node.getUnitTitle());
		if (node.getPID() != null)	for (String s: node.getPID())		dc.addElement("dc:identifier", s);
		addDynamicMetadataValuesToDCElement(node, "origination", dc, "dc:creator");
		addDynamicMetadataValuesToDCElement(node, "author", dc, "dc:creator");
		addDynamicMetadataValuesToDCElement(node, "creationPeriod", dc, "dcterms:temporal");
		addDynamicMetadataValuesToDCElement(node, "creationPeriodNotes", dc, "dc:description");
		addDynamicMetadataValuesToDCElement(node, "scopeContent", dc, "dc:subject");
		addDynamicMetadataValuesToDCElement(node, "language", dc, "dc:language");
		addDynamicMetadataValuesToDCElement(node, "languageNotes", dc, "dc:description");
		addDynamicMetadataValuesToDCElement(node, "accessRestriction", dc, "dc:rights");
//		addDynamicMetadataValuesToDCElement(node, "retentionPolicy", dc, "???");
		addDynamicMetadataValuesToDCElement(node, "retentionPeriodBaseYear", dc, "dc:date");
		addDynamicMetadataValuesToDCElement(node, "archivalHistory", dc, "dc:description");
		addDynamicMetadataValuesToDCElement(node, "objectType", dc, "dc:description");
		addDynamicMetadataValuesToDCElement(node, "extent", dc, "dc:extent");
		addDynamicMetadataValuesToDCElement(node, "refCodeOld", dc, "dc:identifier");
		addDynamicMetadataValuesToDCElement(node, "refCode", dc, "dc:identifier");
		addDynamicMetadataValuesToDCElement(node, "reproductions", dc, "dcterms:hasVersion");
		addDynamicMetadataValuesToDCElement(node, "comment", dc, "dc:description");
		addDynamicMetadataValuesToDCElement(node, "institution", dc, "dc:publisher");
		addDynamicMetadataValuesToDCElement(node, "arrangement", dc, "dc:format");
		addDynamicMetadataValuesToDCElement(node, "accessNr", dc, "dc:source");
		addDynamicMetadataValuesToDCElement(node, "bibliography", dc, "dcterms:isReferencedBy");
		ie.setIEDublinCore(dc);


		// Create DNX with CMS section
		DnxDocumentHelper ieDnxHelper = new DnxDocumentHelper(DnxDocumentFactory.getInstance().createDnxDocument());

		// Insert DNX to IE
		DnxDocument doc = ieDnxHelper.getDocument();
		ie.setIeDnx(doc);

		// Add MARC metadata
		//	ToDo: add complete source dmd section:
//		node.getMyDMDSectionWithEAD().getElement().asXML();
//		XmlObject xml = XmlObject.Factory.parse((org.w3c.dom.Element)node.getMyDMDSectionWithEAD().getElement());
//		ie.setIeSourceMd(gov.loc.mets.MdSecType.MdWrap.MDTYPE.MARC, xml);


		// Add fileGrp:
		FileGrp fGrp = ie.addNewFileGrp(Enum.UsageType.VIEW, Enum.PreservationType.PRESERVATION_MASTER);
		fGrp.setUSE(Enum.UsageType.VIEW.toString());

		// Add dnx - A new DNX is constructed and added on the file group
		DnxDocumentHelper fileGrpDocumentHelper = new DnxDocumentHelper(ie.getFileGrpDnx(fGrp.getID()));
		//	What's set here comes into the rep's amd section:
		fileGrpDocumentHelper.getGeneralRepCharacteristics().setPreservationType(Enum.PreservationType.PRESERVATION_MASTER.toString());
		fileGrpDocumentHelper.getGeneralRepCharacteristics().setUsageType(Enum.UsageType.VIEW.toString());
		fileGrpDocumentHelper.getGeneralRepCharacteristics().setLabel(node.getLabel());
		fileGrpDocumentHelper.getGeneralRepCharacteristics().setContentType("content type???");
		fileGrpDocumentHelper.getGeneralRepCharacteristics().setContextType("context type???");
		fileGrpDocumentHelper.getGeneralRepCharacteristics().setDeliveryPriority("delivery priority???");
		fileGrpDocumentHelper.getGeneralRepCharacteristics().setDerivedFromId("derived from id???");
		fileGrpDocumentHelper.getGeneralRepCharacteristics().setDigitalOriginal("digital original???");
		fileGrpDocumentHelper.getGeneralRepCharacteristics().setHardwareUsed("hardware used???");
		fileGrpDocumentHelper.getGeneralRepCharacteristics().setOrderingSequence("ordering sequence???");
		fileGrpDocumentHelper.getGeneralRepCharacteristics().setPhysicalCarrierMedia("physical carrier media???");
		fileGrpDocumentHelper.getGeneralRepCharacteristics().setRepresentationCode("representation code???");
		fileGrpDocumentHelper.getGeneralRepCharacteristics().setRepresentationEntityType("representation entity type???");
		fileGrpDocumentHelper.getGeneralRepCharacteristics().setRepresentationOriginalName("representation original name???");
		fileGrpDocumentHelper.getGeneralRepCharacteristics().setRevisionNumber("revision nr???");
		fileGrpDocumentHelper.getGeneralRepCharacteristics().setTaskID("task id???");
		ie.setFileGrpDnx(fileGrpDocumentHelper.getDocument(), fGrp.getID());

		if (node.isFile())
		{
			// add file and dnx metadata on file
//			FileType fileType = ie.addNewFile(fGrp, mimeType, file.getName(), "test file");
			FileType fileType = ie.addNewFile(fGrp, "1???", node.getPathString(), "3???");	//	The 2nd argument comes into fileGrp.file.Flocat@xlin:href

			// add dnx - A new DNX is constructed and added on the file level
			DnxDocumentHelper fileDocumentHelper = new DnxDocumentHelper(ie.getFileDnx(fileType.getID()));
			//	What's set here comes into the file's amd section:
			fileDocumentHelper.getGeneralFileCharacteristics().setLabel(node.getLabel());
			fileDocumentHelper.getGeneralFileCharacteristics().setFileOriginalPath(node.getOriginalPathString());
			fileDocumentHelper.getGeneralFileCharacteristics().setFileMIMEType(node.getMimeType());
			fileDocumentHelper.getGeneralFileCharacteristics().setFileOriginalName(node.getFile().getName());
			fileDocumentHelper.getGeneralFileCharacteristics().setFileSizeBytes(node.getSize().toString());
			fileDocumentHelper.getGeneralFileCharacteristics().setCompositionLevel("composition level???");
			fileDocumentHelper.getGeneralFileCharacteristics().setFileCreationDate("file creation date???");
			fileDocumentHelper.getGeneralFileCharacteristics().setFileEntityType("file entity type???");
			fileDocumentHelper.getGeneralFileCharacteristics().setFileExtension("file extension???");
			fileDocumentHelper.getGeneralFileCharacteristics().setFileLocation("file location???");
			fileDocumentHelper.getGeneralFileCharacteristics().setFileLocationType("file location type???");
			fileDocumentHelper.getGeneralFileCharacteristics().setFileModificationDate("file modification date???");
			fileDocumentHelper.getGeneralFileCharacteristics().setFileOriginalID("file original id???");
			fileDocumentHelper.getGeneralFileCharacteristics().setFormatLibraryId("format library id???");
			fileDocumentHelper.getGeneralFileCharacteristics().setNote("note???");
			fileDocumentHelper.getGeneralFileCharacteristics().setRiskLibraryIdentifiers("risk library ids???");
			ie.setFileDnx(fileDocumentHelper.getDocument(), fileType.getID());

			// Copy the file we are ingesting into ".../content/streams":
			FileUtil.copyToFolderOverwriting(node.getAbsolutePathString(), streamsFilePath);
		}
		else
		{
			//	Insert all containing files within this folder, ignore containing folders:
			for (NodeFile subNode: ((NodeFolder)node).getDescendantFiles())
			{
				Tracer.trace("Adding file to complex IE in '" + destinationFolder + "' for: " + subNode.getLabel());

				// add file and dnx metadata on file
	//			FileType fileType = ie.addNewFile(fGrp, mimeType, file.getName(), "test file");
				FileType fileType = ie.addNewFile(fGrp, "1???", subNode.getPathString(), "3???");	//	The 2nd argument comes into fileGrp.file.Flocat@xlin:href

				// add dnx - A new DNX is constructed and added on the file level
				DnxDocumentHelper fileDocumentHelper = new DnxDocumentHelper(ie.getFileDnx(fileType.getID()));
				//	What's set here comes into the file's amd section:
				fileDocumentHelper.getGeneralFileCharacteristics().setLabel(subNode.getUnitTitle());
				fileDocumentHelper.getGeneralFileCharacteristics().setFileOriginalPath(subNode.getOriginalPathString());
				fileDocumentHelper.getGeneralFileCharacteristics().setFileMIMEType(subNode.getMimeType());
				fileDocumentHelper.getGeneralFileCharacteristics().setFileOriginalName(subNode.getFile().getName());
				fileDocumentHelper.getGeneralFileCharacteristics().setFileSizeBytes(subNode.getSize().toString());
				fileDocumentHelper.getGeneralFileCharacteristics().setCompositionLevel("composition level???");
				fileDocumentHelper.getGeneralFileCharacteristics().setFileCreationDate("file creation date???");
				fileDocumentHelper.getGeneralFileCharacteristics().setFileEntityType("file entity type???");
				fileDocumentHelper.getGeneralFileCharacteristics().setFileExtension("file extension???");
				fileDocumentHelper.getGeneralFileCharacteristics().setFileLocation("file location???");
				fileDocumentHelper.getGeneralFileCharacteristics().setFileLocationType("file location type???");
				fileDocumentHelper.getGeneralFileCharacteristics().setFileModificationDate("file modification date???");
				fileDocumentHelper.getGeneralFileCharacteristics().setFileOriginalID("file original id???");
				fileDocumentHelper.getGeneralFileCharacteristics().setFormatLibraryId("format library id???");
				fileDocumentHelper.getGeneralFileCharacteristics().setNote("note???");
				fileDocumentHelper.getGeneralFileCharacteristics().setRiskLibraryIdentifiers("risk library ids???");
				ie.setFileDnx(fileDocumentHelper.getDocument(), fileType.getID());

				//	Copy file:
				FileUtil.copyToFolderOverwriting(subNode.getAbsolutePathString(), streamsFilePath);
			}
		}

		//	Finalization:

		//	Generate checksum:
//		ie.generateChecksum(streamsFilePath, Enum.FixityType.MD5.toString());
//		ie.updateSize(streamsFilePath);

		//	Create structmap:
		ie.generateStructMap(null, null, "Table of Contents");

		// Save IE into the content directory:
		com.exlibris.core.sdk.utils.FileUtil.writeFile(new File(ieFilePath), ie.toXML());

		// print the ie:
//		System.out.println(ie.toXML());
	}


	static private void addDynamicMetadataValuesToDCElement(NodeAbstract node, String mdName, DublinCore dc, String elementName) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException
	{
		for (String s: node.getAllDynamicMetadataValuesForName(mdName))		if (s != null)		dc.addElement(elementName, s);
	}

	//	--------		Utilities			-------------------------------------------------------
	//	---------		Misc				-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------
	//	---------		Temporary			-------------------------------------------------------

	//	===========================================================================================
	//	========	Inner Classes			=======================================================
	//	===========================================================================================

}
